﻿var modalDialog = {
    type: null,
    headerHeight: 40,
    footerHeight: 40,
    bodyDefaultPostitionValue: null,
    bodyDefaultOverflowValue: null,
    removeScrollBars: function () {
        bodyDefaultOverflowValue = document.body.style.overflow;
        document.body.style.overflow = "hidden";
    },
    addScrollBars: function () {
        document.body.style.overflow = bodyDefaultOverflowValue;
    },
    clearModernEditor: function () {
        //Tests IE
        //this.destroyAutoCompletes();

        if (!($.fancybox.inner == null || this.type == 'iframe')) {
            $(".modernEditor:last", $.fancybox).remove();
        }
    },
    destroyAutoCompletes: function () {
        if (typeof (a4) != "undefined") {
            var autoCompletes = a4.top().autoCompletes;

            if (autoCompletes && $.fancybox.inner && $.fancybox.inner.length > 0) {
                _.each(autoCompletes[$.fancybox.inner[0].firstChild.name], function (autoComplete) {
                    autoComplete.destroy();
                });
            }
        }
    },
    afterShow: function () {
        this.autoFocusFirstField();
        //var html = $('.fancybox-iframe').contents().find('html');
        //html.css("overflow", "hidden");
        //$(".content", html).height($(".content", html).height());
        //$(".content", html).width($(".content", html).width());
        //$(".content", html).mCustomScrollbar();
    },

    autoFocusFirstField: function () {
        $('.fancybox-iframe').contents().find(':input:visible:enabled:first').focus();
    },

    autoBind: function (cssClass, height, width) {
        this.type = 'iframe';

        if (!width)
            width = height * 1.618;

        $("." + cssClass).fancybox({
            type: 'iframe',
            padding: 0,
            autoSize: false,
            height: height,
            width: width,
            helpers: {
                overlay: {
                    closeClick: false
                }
            },
            beforeShow: function () {
                modalDialog.removeScrollBars();
            },
            afterShow: function () {
                modalDialog.autoFocusFirstField()
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.addScrollBars();
            }
        });
    },

    showWindow: function (href, height, width, options) {
        this.type = 'iframe';

        var initFunction = null;
        var beforeClose = null;
        var afterClose = null;
        var content = null;

        var ref = this;

        if (options) {
            if (options.initFunction)
                initFunction = options.initFunction;
            if (options.beforeClose)
                beforeClose = options.beforeClose;
            if (options.afterClose)
                afterClose = options.afterClose;
        }

        if (!width)
            width = height * 1.618;

        $.fancybox({
            type: 'iframe',
            href: href,
            padding: 0,
            autoSize: false,
            height: height,
            width: width,
            helpers: {
                overlay: {
                    closeClick: false
                }
            },
            beforeShow: function () {
                modalDialog.removeScrollBars();
            },
            afterShow: function () {
                if (initFunction) {
                    initFunction();
                }
                else {
                    modalDialog.autoFocusFirstField();
                }
            },
            beforeClose: function () {
                if (beforeClose) {
                    beforeClose();
                }

                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.addScrollBars();

                if (afterClose) {
                    afterClose();
                }
            }
        });
    },

    showAjaxWindow: function (href, height, width, afterShow) {
        this.type = 'ajax';

        if (!width)
            width = height * 1.618;

        $.fancybox({
            type: 'ajax',
            href: href,
            padding: 0,
            autoSize: false,
            height: height,
            width: width,
            helpers: {
                overlay: {
                    closeClick: false
                }
            },
            beforeShow: function () {
                modalDialog.removeScrollBars();
            },
            afterShow: function () {
                afterShow()
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.addScrollBars();
            }
        });
    },

    createDialogResources: function (message, title, checkBoxText) {
        return { "Message": message, "Title": title, "CheckBoxText": checkBoxText };
    },

    showConfirmDialog: function (resources, yesFunction, height, width, addCheckboxConfirm, args, options) {
        var modernEditor = $('<div class="modernEditor" />');

        var title = resources["Title"];
        var titleContent = "";
        if (title) {
            if (args) {
                title = title.replace(/{(.*?)}/g, function (group, value) {
                    return args[value];
                });
            }

            titleContent = title;
        }
        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(titleContent));
        modernEditor.append(editorHeader);

        var message = resources["Message"];
        if (args) {
            message = message.replace(/{(.*?)}/g, function (group, value) {
                return args[value];
            });
        }

        var editorContent = $('<div class="content" />');
        var editorWrappedContent = $('<div class="wrapper" />').html(message);

        editorContent.append(editorWrappedContent);

        var confirmCheckBox;

        if (addCheckboxConfirm) {
            confirmCheckBox = $('<input id="confirmCheck" type="checkbox" />');
            editorWrappedContent.append($('<div class="confirmCheck" />')
                            .append(confirmCheckBox)
                            .append($('<label for="confirmCheck"/>').html(resources["CheckBoxText"]))
                         );
        }

        modernEditor.append(editorContent);

        var initFunction = null;
        var validateFunction = null;
        var cancelFunction = null;
        var saveButtonText = sharedResources.Confirm;
        var cancelButtonText = sharedResources.Cancel;
        var closeButtonText = sharedResources.Cancel;
        var showCancelButton = true;
        var showCloseButton = false;

        if (options) {
            if (options.cancel)
                cancelFunction = options.cancel;

            if (options.saveButtonText)
                saveButtonText = options.saveButtonText;

            if (options.cancelButtonText)
                cancelButtonText = options.cancelButtonText;

            if (options.cancelFunction)
                cancelFunction = options.cancelFunction;

            if (options.initFunction)
                initFunction = options.initFunction;

            if (options.validateFunction)
                validateFunction = options.validateFunction;

            if (options.hideCancelButton)
                showCancelButton = !options.hideCancelButton;

            if (options.showCloseButton)
                showCloseButton = options.showCloseButton;
        }

        var saveButton = $('<span />', { "class": "button primary" }).text(saveButtonText).bind("click",
            function () {
                if (!$(this).prop("disabled")) {
                    var valid = (validateFunction == null || validateFunction());

                    if (valid) {
                        yesFunction()
                        modalDialog.close();
                    }
                }
            });

        var cancelButton = $('<span />', { "class": "link-button" }).text(cancelButtonText).bind("click",
            function () {
                if (cancelFunction) {
                    cancelFunction();
                }
                modalDialog.close();
            });

        if (confirmCheckBox) {
            saveButton.prop('disabled', true);
            saveButton.addClass("disabled");
            confirmCheckBox.bind("change", function () {
                var checked = $(this).prop('checked');
                saveButton.prop('disabled', !checked);
                saveButton.toggleClass("disabled", !checked);
            });
        }

        var editorFooter = $('<div class="footer" />').append(saveButton);

        if (showCancelButton) {
            editorFooter = editorFooter.append(cancelButton);
        }

        if (showCloseButton) {
            var closeButton = $('<span />', { "class": "link-button" }).text(closeButtonText).bind("click", function () { modalDialog.close(); });
            editorFooter = editorFooter.append(closeButton);
        }

        modernEditor.append(editorFooter);
        this.type = 'html';

        if (!width)
            width = height * 1.618;

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            autoSize: false,
            width: width,
            height: height,
            autoSize: false,
            beforeShow: function () {
                modalDialog.removeScrollBars();
            },
            afterShow: function () {
                if (initFunction)
                    initFunction();
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.addScrollBars();
            },
            helpers:
            {
                overlay: {
                    locked: true
                }
            }
        });
    },

    showRequiredActionDialog: function (resources, yesFunction, noFunction, height, width, showClose) {
        modalDialog.showConfirmDialog(resources, yesFunction, height, width, null, null, { cancel: noFunction, showCloseButton: showClose, saveButtonText: resources['SaveButtonText'], cancelButtonText: resources['CancelButtonText'] });
    },

    renderSimpleFormDialog: function (resources, inputs, saveFunction) {
        var modernEditor = $('<div class="modernEditor" />');
        var inputsHeight = 0;

        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(resources["Title"]));
        modernEditor.append(editorHeader);

        var editorContent = $('<div class="content" />');

        _.each(inputs, function (input) {
            var editorField = $('<div />', { "class": "field clearfix" });
            var fieldClass = "";

            if (typeof input.Label !== "undefined" && !(input.Label === null)) {
                editorField.append($('<div />', { "class": "label" }).html(input.Label));
                fieldClass = "inputField";
            }

            var inputStyle = typeof input.Style !== "undefined" ? input.Style : "";

            if (typeof input.Type !== "undefined" && input.Type == "textarea") {
                editorField.append($('<div />', { "class": fieldClass }).append($('<textarea />', { "style": "height:300px;" + inputStyle, "data-fieldname": input.Name }).val(input.Value)));
                inputsHeight += 310;
            } else {
                editorField.append($('<div />', { "class": fieldClass }).append($('<input />', { "type": "text", "data-fieldname": input.Name }).val(input.Value)));
                inputsHeight += 45;
            }

            editorContent.append(editorField);
        });

        modernEditor.append(editorContent);

        var confirmButton = resources["ConfirmButton"] ? $('<span />', { "class": "button primary" }).html(resources["ConfirmButton"]).bind("click", function () {
            var items = {};
            $(".field input, .field textarea", modernEditor).each(function () {
                items[$(this).attr("data-fieldname")] = $(this).val();
            });

            saveFunction(items);
            modalDialog.close();
        }) : $('<span />');

        var cancelButton = $('<span />', { 'class': 'link-button' }).html(resources["CancelButton"]).bind("click", function () { modalDialog.close(); });

        var editorFooter = $('<div class="footer" />').append(confirmButton).append(cancelButton)
        modernEditor.append(editorFooter);

        this.type = 'html';

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            width: 500,
            height: 98 + inputsHeight,
            autoSize: false,
            beforeShow: function () {
                modalDialog.removeScrollBars();
            },
            afterShow: function () {
                $('.modernEditor').find(':input:visible:enabled:first').focus();
            },
            beforeClose: function () {
                modalDialog.clearModernEditor();
            },
            afterClose: function () {
                modalDialog.addScrollBars();
            }
        });
    },

    getTopWindow: function () {
        var window;

        if ($.fancybox.inner == null || this.type == 'iframe') {
            window = a4.parent().$.fancybox;
        }
        else {
            window = $.fancybox;
        }

        return window;
    },

    close: function () {
        this.getTopWindow().close();
        return false;
    },

    resize: function (height, width) {
        if (height || width) {
            var fancybox = this.getTopWindow();

            var outer = $(".fancybox-wrap", a4.parent().document);
            var inner = $(".fancybox-inner", a4.parent().document);

            if (height) {
                outer.height(height);
                inner.height(height);

                fancybox.current.height = height;
            }

            if (width) {
                outer.width(width);
                inner.width(width);

                fancybox.current.width = width;
            }

            fancybox.reposition();
        }
    }
};